using Microsoft.VisualBasic;
using System;
using Microsoft.Reporting.WinForms;


namespace StrataFlix.Reporting
{
	namespace Reports
	{
		namespace MovieListing
		{
			
			
			public class MovieListingDataSource : ReportDataSource<MoviesBBS>
			{
				
				
				#region " Public Methods "
				
				/// <summary>
				/// Populate the data source for the report
				/// </summary>
				/// <remarks></remarks>
				public override bool PopulateDataSource()
				{
					//-- Establish Locals
					StrataFlix.UI.BrowseDialogs.MoviesBrowseDialog movieBrw = new StrataFlix.UI.BrowseDialogs.MoviesBrowseDialog();
					
					//-- Set the BO to populate
					movieBrw.BusinessObjectToPopulate = this.DataSource.SourceBO;
					
					//-- For this instance, force the focus to the results after the query so that the
					//   OK button will come on if there are any results in the list
					movieBrw.SetFocusToResultsAfterSearch = true;
					
					//-- Change the header title
					movieBrw.HeaderTitle = "Movie Listing";
					
					//-- In this case we are just using the Movie Browse to populate the source BO.  But
					//   a custom dialog could just as easily be shown instead.
					if (movieBrw.ShowDialog() == System.Windows.Forms.DialogResult.OK)
					{
						//-- Force the sort to title name
						this.DataSource.SourceBO.Sort = "mv_Title";
						
						//-- Set the report information
						this.LocalReport.DisplayName = "Movie Listing";
                        this.LocalReport.ReportEmbeddedResource = "StrataFlix.Reporting.Reports.Movie_Listing.MovieListing.rdlc";
						
						//-- Create the LocalReport data sources
						this.LocalReport.DataSources.Add(new ReportDataSource("Source", this.DataSource));
						
						//-- Indicate that the data source was populated
						return true;
					}
					else
					{
						//-- There is no reason to continue since the browse was cancelled
						return false;
					}
				}
				
				#endregion
				
			}
			
		}
	}
}
